const mongoose = require("mongoose");
const User = require("./models/User");
require("dotenv").config();

mongoose.connect(process.env.MONGO_URI)
    .then(async () => {
        console.log("DB Connected");
        const users = await User.find({});
        console.log("Users in DB:");
        users.forEach(u => console.log(`- ${u.email} (${u.role})`));
        process.exit();
    })
    .catch(err => {
        console.error(err);
        process.exit(1);
    });
